%--------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      GenSensorData6.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
% Class:          PSYCH221
% Description:    This routine determines all the possible sensor 
%                 settings that will be used for a 6-color sensor and 
%                 saves the result in the file SensorData6.mat. Each 
%                 row contains the following:
%                 Width1 Width2 Width3 Width4 Width5 Width6 Pos1 Pos2
%                 Pos3 Pos4 Pos5 Pos6
%--------------------------------------------------------------------------

if ieNotDefined('numSensors'), numSensors = 6 ; end
NumSims = 1000;     % Number of simulations that we would like to do

% Initialize the project settings
InitializeProject;

% Separate the filters linearly across the spectrum
UniformSensorPos = linspace(minWavelength,maxWavelength,numSensors);
UniformSensorWidth = (UniformSensorPos(2)-UniformSensorPos(1))/2.2;

sensorPosSpacing = 35;      % Wavelength between different sensor options
NumWidths = 3;
sensorWidthSpacing = 7;     % Different sensor widths
minSensorWidth = UniformSensorWidth - 0.5*(NumWidths-1)*sensorWidthSpacing;        % Minimum sensor width
maxSensorWidth = UniformSensorWidth + 0.5*(NumWidths-1)*sensorWidthSpacing;        % Maximum sensor width
minGreen = 478;             % Minimum green position
maxGreen = 555;             % Maximum green position

% Set up a matrix with all possible sensor positions 
sensorPos_all = [];
sensorWidth_all = [];
sensorSettings_all = [];

% Calculate the sensor widths
%-----------------------------

Widths = [minSensorWidth:sensorWidthSpacing:maxSensorWidth]';
NumWidths = length(Widths);

OldStage = Widths;
NewStage = [];

for Stage = 1:1:(numSensors-1)
    NSOld = size(OldStage,1);
    for WIdx = 1:1:NumWidths
        NewStage = [NewStage ; [Widths(WIdx).*ones(NSOld,1), OldStage]];
    end
    OldStage = NewStage;
    NewStage = [];
end

sensorWidth_all = OldStage;

% Calculate the sensor positions - Faster version
%--------------------------------------------------
NPos_all = 0;
% Count the number of positions so that we can preallocate memory
for Pos3 = minGreen:sensorPosSpacing:maxGreen,
    for Pos2 = (minWavelength + sensorPosSpacing):sensorPosSpacing:(Pos3 - sensorPosSpacing),
        for Pos1 = minWavelength:sensorPosSpacing:(Pos2 - sensorPosSpacing),
            for Pos4 = (Pos3 + sensorPosSpacing):sensorPosSpacing:(maxWavelength - 2*sensorPosSpacing),
                for Pos5 = (Pos4 + sensorPosSpacing):sensorPosSpacing:(maxWavelength - sensorPosSpacing),
                    for Pos6 = (Pos5 + sensorPosSpacing):sensorPosSpacing:maxWavelength,
                        NPos_all = NPos_all + 1;
                    end
                end
            end
        end
    end
end

sensorPos_all = zeros(NPos_all,numSensors);
PosIdx = 1;
for Pos3 = minGreen:sensorPosSpacing:maxGreen,
    for Pos2 = (minWavelength + sensorPosSpacing):sensorPosSpacing:(Pos3 - sensorPosSpacing),
        for Pos1 = minWavelength:sensorPosSpacing:(Pos2 - sensorPosSpacing),
            for Pos4 = (Pos3 + sensorPosSpacing):sensorPosSpacing:(maxWavelength - 2*sensorPosSpacing),
                for Pos5 = (Pos4 + sensorPosSpacing):sensorPosSpacing:(maxWavelength - sensorPosSpacing),
                    for Pos6 = (Pos5 + sensorPosSpacing):sensorPosSpacing:maxWavelength,
                        sensorPos_all(PosIdx,:) = [Pos1 Pos2 Pos3 Pos4 Pos5 Pos6];
                        PosIdx = PosIdx + 1;
                    end
                end
            end
        end
    end
end

% Combine the positions and the widths - Faster version
%--------------------------------------------------------
NumRows = size(sensorWidth_all,1)*size(sensorPos_all,1);
NumCols = size(sensorWidth_all,2) + size(sensorPos_all,2);
NewStage = zeros(NumRows, NumCols);
OldStage = sensorPos_all;

NSOld = size(OldStage,1);
NumWidths = size(sensorWidth_all,1);
for WIdx = 1:1:NumWidths;
    %fprintf('Width %d of %d \n',WIdx,NumWidths);
    NewStage(((WIdx-1)*NSOld+1):(WIdx*NSOld),:) = [repmat(sensorWidth_all(WIdx,:),NSOld,1), OldStage];
end

sensorSettings_all = NewStage;

% Sample only NumSims of these
disp('Number of sensors, before choosing uniformly:');
size(sensorSettings_all,1)


SampleRows = round(rand(NumSims,1)*size(sensorSettings_all,1));
[Min,MinIdx] = min(SampleRows);
[Max,MaxIdx] = max(SampleRows);

if(Min < 1)
   SampleRows(MinIdx) = 1;
end
if(Max > size(sensorSettings_all,1))
   SampleRows(MinIdx) = size(sensorSettings_all,1);
end

% Save the names of the parameters that we are changing
sensorSettings_Names = {'Width1','Width2','Width3','Width4','Width5','Width6','Pos1','Pos2','Pos3','Pos4','Pos5','Pos6'};

% Save the sensor data
sensorSettings = sensorSettings_all(SampleRows,:);
save('SensorData6.mat', 'sensorSettings_Names', 'sensorSettings');

% Display what all the sensor settings are:
disp(sensorSettings_Names)
sensorSettings










